package gov.va.med.mhv.getcare.web.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.annotation.Resource;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.getcare.common.dto.TreatmentFacilityDTO;
import gov.va.med.mhv.getcare.service.TreatmentFacilityService;
import gov.va.med.mhv.getcare.web.compare.TreatmentFacilityDTOByTypeCompare;
import gov.va.med.mhv.getcare.web.compare.TreatmentFacilityDTOByNameCompare;
import gov.va.med.mhv.getcare.web.util.FacesUtil;
import gov.va.med.mhv.getcare.web.util.WebServiceClientUtil;

@ManagedBean
@Component
@Scope("session")
public class TreatementLocationsController extends AbstractController {
	private static final long serialVersionUID = -3199106302303215607L;
	private static Logger log = LogManager.getLogger(TreatementLocationsController.class);
	
	private static final String FACILITY_DATATABLE = "locationForm:facList";

	private DataTable facilityTable = new DataTable();

	private List<TreatmentFacilityDTO> facilities = new ArrayList<TreatmentFacilityDTO>();
	private TreatmentFacilityDTO selectedFacility = new TreatmentFacilityDTO();
	private TreatmentFacilityDTO newFacility = new TreatmentFacilityDTO();

	@Resource(name = "treatmentFacilityServiceProxy")
	private TreatmentFacilityService treatmentFacilityService;

	public void init(ComponentSystemEvent event) {

		try {
			log.debug("init");

			if (!FacesContext.getCurrentInstance().isPostback()) {
				log.debug("Not postBack");
				findUser();
				userprofileId = getUserProfileIdFromSession();
				if (userprofileId != null) {
					loadModel();
				}
				resetMessages();
				setRowsPerPage(10);
			} else {
				log.debug("postBack");
				facilityTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("locationForm:facList");
				if (sortColumn != null && sortBy != null) {
					facilityTable.setValueExpression("sortBy", sortColumn);
					facilityTable.setSortOrder(sortBy);
				}
			}
		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}
	}
	
	private void loadModel() {
		List<TreatmentFacilityDTO> dtoList = null;
		
		try {
			log.debug("loadModel");
			Long userProfileId = getUserProfileIdFromSession();
			log.debug("userProfileId=" + userProfileId);
			dtoList = treatmentFacilityService.findFacilitiesForUser(userProfileId);
			
			if (dtoList != null) {
				Collections.sort(dtoList, new TreatmentFacilityDTOByNameCompare());
				 facilities = dtoList;
			} else {
				facilities.clear();
			}
		} catch (MHVException e) {
			log.error(e);
			super.processErrorMessages(e);
		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}
	}

	public void onSort(SortEvent event) {
		sortColumn = event.getSortColumn().getValueExpression("sortBy");
		sortBy = event.isAscending() ? "ascending" : "descending";
	}

	public int sortByName(Object ob1, Object ob2) {
		int retValue = 0;
		TreatmentFacilityDTO fac1 = (TreatmentFacilityDTO) ob1;
		TreatmentFacilityDTO fac2 = (TreatmentFacilityDTO) ob2;
		
		Boolean asc = FacesUtil.getSortColumnAscending(FACILITY_DATATABLE);
		
		TreatmentFacilityDTOByNameCompare treatmentFacilityDTOCompare = new TreatmentFacilityDTOByNameCompare(asc);
		retValue = treatmentFacilityDTOCompare.compare(fac1, fac2);

		return retValue;
	}

	public int sortByType(Object ob1, Object ob2) {
		int retValue = 0;
		TreatmentFacilityDTO fac1 = (TreatmentFacilityDTO) ob1;
		TreatmentFacilityDTO fac2 = (TreatmentFacilityDTO) ob2;
		
		Boolean asc = FacesUtil.getSortColumnAscending(FACILITY_DATATABLE);
		
		TreatmentFacilityDTOByTypeCompare treatmentFacilityDTOByTypeCompare = new TreatmentFacilityDTOByTypeCompare(asc);
		retValue = treatmentFacilityDTOByTypeCompare.compare(fac1, fac2);

		return retValue;
	}

	public String showDetail(TreatmentFacilityDTO facility) {
		resetMessages();
		selectedFacility = facility;
		return "treatmentLocation";
	}

	public String editDisplay(TreatmentFacilityDTO facility) {
		resetMessages();
		selectedFacility = facility;
		return "editTreatmentLocationDisplay";
	}

	public String deleteDisplay(TreatmentFacilityDTO facility) {
		resetMessages();
		selectedFacility = facility;
		setDeleteOrigin("tableView");
		return "deleteTreatmentLocationDisplay";
	}

	public String deleteRecordDisplay() {
		resetMessages();
		setDeleteOrigin(null);
		return "deleteTreatmentLocationDisplay";
	}

	public String addDisplay() {
		resetMessages();
		newFacility = new TreatmentFacilityDTO();
		newFacility.setFacilityType("V");
		return "addTreatmentLocationDisplay";
	}

	public String printerFriendlySummary() {
		facilityTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("locationForm:facList");
		return "printTreatmentLocationSummary";
	}

	public String save() {
		String outcome = null;
		try {
			ResponseUtil response = saveFacility();
			if (response.isSuccess()) {
				loadModel();
				outcome = "treatmentLocationList";
				saveMessage = true;
			} else {
				super.processErrorMessages(response);
			}
		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}

		return outcome;
	}

	public String saveAndAdd() {
		String outcome = null;
		try {
			ResponseUtil response = saveFacility();
			if (response.isSuccess()) {
				loadModel();
				outcome = "addTreatmentLocationDisplay";
				saveAndAddMessage = true;
				newFacility = new TreatmentFacilityDTO();
				newFacility.setFacilityType("V");
			} else {
				super.processErrorMessages(response);
			}

		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}

		return outcome;
	}

	public String backToList() {
		resetMessages();
		return "treatmentLocationList";
	}

	public String dashboardAddDisplay() throws MHVException {
		resetMessages();
		findUser();
		setRowsPerPage(10);
		userprofileId = getUserProfileIdFromSession();
		
		if (userprofileId != null) {
			loadModel();
		}
		
		newFacility = new TreatmentFacilityDTO();
		newFacility.setFacilityType("V");

		return "/views/treatmentlocations/addTreatmentLocationDisplay";
	}

	public String dashboardViewMore() throws MHVException{
		resetMessages();
		findUser();
		setRowsPerPage(10);
		userprofileId = getUserProfileIdFromSession();
		if (userprofileId != null) {
			loadModel();
		}

		return "/views/treatmentlocations/treatmentLocationList";
	}

	public String showDahBoardDetail() throws MHVException {
		resetMessages();
		findUser();
		String facilityid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("facilityid");
		if (facilityid != null) {
			Long id = Long.valueOf(facilityid);
			selectedFacility = findFacilityByid(id);
		}
		return "/views/treatmentlocations/treatmentLocation";
	}

	private List<TreatmentFacilityDTO> findFacilities() {
		List<TreatmentFacilityDTO> dtoList = null;		
		try {
			Long userProfileId = getUserProfileIdFromSession();
			log.debug("findFacilities userprofileId=" + userprofileId);
			dtoList = treatmentFacilityService.findFacilitiesForUser(userprofileId);
		} catch (MHVException e) {
			log.error(e);
			super.processErrorMessages(e);
		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}

		return dtoList;
	}

	private TreatmentFacilityDTO findFacilityByid(Long id) {
		TreatmentFacilityDTO dto = null;

		try {
			dto = treatmentFacilityService.findByPrimaryKey(id);
		} catch (MHVException e) {
			log.error(e);
			super.processErrorMessages(e);
		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}

		return dto;
	}

	public String delete() {
		String outcome = null;
		String facilityid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("facilityid");
		ResponseUtil response = new ResponseUtil();

		log.debug("delete");

		try {
			if (facilityid != null) {
				Long id = Long.valueOf(facilityid);
				response = treatmentFacilityService.delete(id);

				if (!response.isSuccess()) {
					log.debug("Failed to Delete Facility", response.getFailureMessage());
					WebServiceClientUtil.showErrorMessage();
				} else {
					deleteMessage = true;
					loadModel();
					outcome = "treatmentLocationList";
				}
			}
		} catch (MHVException e) {
			log.error(e);
			super.processErrorMessages(e);
		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}

		return outcome;
	}

	public ResponseUtil saveFacility() throws MHVException {
		resetMessages();
		ResponseUtil response = new ResponseUtil();
		String facilityid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("facilityid");
		TreatmentFacilityDTO facility = null;
		if (facilityid != null) {
			facility = getSelectedFacility();
		} else {
			facility = getNewFacility();
		}
		facility.setUserProfileId(getUserProfileIdFromSession());

		try {
			response = treatmentFacilityService.save(facility);
		} catch (MHVException e) {
			super.processErrorMessages(ResponseUtil.toResponseUtil(e));
		}

		return response;
	}

	private TreatmentFacilityDTO prepareFacility(TreatmentFacilityDTO facility) throws MHVException {
		facility.setUserProfileId(getUserProfileIdFromSession());
		return facility;
	}

	public List<TreatmentFacilityDTO> getFacilities() {
		return facilities;
	}

	public void setFacilities(List<TreatmentFacilityDTO> facilities) {
		this.facilities = facilities;
	}

	public DataTable getFacilityTable() {
		return facilityTable;
	}

	public void setFacilityTable(DataTable facilityTable) {
		this.facilityTable = facilityTable;
	}

	public TreatmentFacilityDTO getSelectedFacility() {
		return selectedFacility;
	}

	public void setSelectedFacility(TreatmentFacilityDTO selectedFacility) {
		this.selectedFacility = selectedFacility;
	}

	public TreatmentFacilityDTO getNewFacility() {
		return newFacility;
	}

	public void setNewFacility(TreatmentFacilityDTO newFacility) {
		this.newFacility = newFacility;
	}

}
